<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Epices extends Model 
{

    protected $table = 'epices';
    public $timestamps = true;
    protected $fillable = array('id_category', 'name', 'short_description', 'description', 'number', 'image_url', 'price', 'stock', 'guid', 'id_tax', 'status');
    protected $visible = array('id_category', 'name', 'short_description', 'description', 'number', 'image_url', 'price', 'stock', 'guid', 'id_tax', 'status');

    public function category()
    {
        return $this->belongsTo('App\Models\Category', 'id_category');
    }

    public function product_meta()
    {
        return $this->hasOne('App\Models\Product_meta', 'id_epice');
    }

    public function tax()
    {
        return $this->belongsTo('App\Models\Tax', 'id_tax');
    }

    public function promotions()
    {
        return $this->hasMany('App\Models\Promotion', 'id_epice');
    }

    public function reviews()
    {
        return $this->hasMany('App\Models\Reviews', 'id_epice');
    }

}